/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.heal;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class HealingUpgrade
extends Upgrade {
    private int cooldown = 10;

    public HealingUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)((Object)SimplePlanesUpgrades.HEALING.get()), planeEntity);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("cooldown", this.cooldown);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag compoundNBT) {
        this.cooldown = compoundNBT.m_128451_("cooldown");
    }

    @Override
    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            this.remove();
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
    }

    @Override
    public void onApply(ItemStack itemStack, Player playerEntity) {
        int m;
        int health = this.planeEntity.getHealth();
        if (health < (m = this.planeEntity.getMaxHealth() * 2)) {
            int heal = this.planeEntity.getOnGround() ? 2 : 1;
            this.planeEntity.setHealth(Math.min(health + heal, m));
        }
        this.planeEntity.goldenHeartsTimeout = 0;
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void onRemoved() {
    }
}

